package imi.pmf.sprint;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

import java.util.ArrayList;
import java.util.List;

import static org.junit.jupiter.api.Assertions.*;

class AktvniSprintTest {

    @InjectMocks
    AktvniSprint aktvniSprint; // SUT

    @Mock
    private ZadaciNaCekanju zadaciNaCekanju;

    @Mock
    private Zaposleni zaposleni;

    AutoCloseable closeable;

    @BeforeEach
    void setUp(){
        closeable = MockitoAnnotations.openMocks(this);
    }
    @AfterEach
    void close() throws Exception {
        closeable.close();
    }
    @Test
    void dodajZadatakUAktivniSprintInzenjeru() {
        Zadatak trazeniZadatak = Mockito.mock(Zadatak.class);
        Mockito.when(zadaciNaCekanju.preuzmiZadatakPoNazivu(Mockito.matches("^(z|Z)ad 1$")))
                .thenReturn(trazeniZadatak);
        Osoba inzenjer = Mockito.mock(Osoba.class);
        Mockito.when(inzenjer.getIme()).thenReturn("Pera");
        Mockito.when(inzenjer.getPozicija()).thenReturn("inzenjer");

        Mockito.when(zaposleni.pronadjiOsobuPoImenu(Mockito.matches("^Pera$")))
                .thenReturn(inzenjer);

        String rezultat = aktvniSprint.dodajZadatakUAktivniSprint("Zad 1", "Pera");
        assertEquals("Zadatak je uspeno dodeljen.", rezultat);
    }

    @Test
    void dodajZadatakUAktivniSprintMenadzeru() {
        Zadatak trazeniZadatak = Mockito.mock(Zadatak.class);
        Mockito.when(zadaciNaCekanju.preuzmiZadatakPoNazivu(Mockito.matches("^(z|Z)ad 1$")))
                .thenReturn(trazeniZadatak);
        Osoba inzenjer = Mockito.mock(Osoba.class);
        Mockito.when(inzenjer.getIme()).thenReturn("Pera");
        Mockito.when(inzenjer.getPozicija()).thenReturn("menadzer");

        Mockito.when(zaposleni.pronadjiOsobuPoImenu(Mockito.matches("^Pera$")))
                .thenReturn(inzenjer);

        String rezultat = aktvniSprint.dodajZadatakUAktivniSprint("Zad 1", "Pera");
        assertEquals("Zadatak nije moguce dodeliti menadzeru.", rezultat);


    }

}